using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a glowing ratman corpse" )]
	public class Rikkecrat : BaseChampion
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.CrushingBlow;
				case 1: return WeaponAbility.ArmorIgnore;
				case 2: return WeaponAbility.ParalyzingBlow;
			}
		}

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public Rikkecrat() : this (false, 3)
		{
		}

		[Constructable]
		public Rikkecrat(int range) : this (false, range)
		{
		}

		[Constructable]
		public Rikkecrat(bool ischampion, int range) : base(AIType.AI_Necromage, FightMode.Closest, ischampion, range)
		{
			Name = "Rikkec'rat";
			Title = ", zablesenec";
			Body = 0x8F;
			BaseSoundID = 437;

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetInt(1000, 1200);

			SetHits(50000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 30);

			SetDamageType(ResistanceType.Energy, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 70, 75);
			SetResistance(ResistanceType.Fire, 80, 90);
			SetResistance(ResistanceType.Cold, 70, 75);
			SetResistance(ResistanceType.Poison, 70, 75);
			SetResistance(ResistanceType.Energy, 75, 80);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 150.1, 160.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 120.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			DropMin = 50;
			DropMax = 100;
			BonusLoot = "tokens";
			BonusLootAmount = Utility.RandomMinMax(15, 30);

			Item reags = Loot.RandomReagent();
			reags.Amount = 30;
			PackItem(reags);

			PackNecroReg(40, 100);

			if(0.05 > Utility.RandomDouble())
				PackItem(ClothingSkillScroll.CreateRandomNoCraft(1, Utility.RandomList(1, 1, 1, 1, 1, 1, 2, 2, 3)));

			if(0.5 > Utility.RandomDouble())
				PackItem((Item)Activator.CreateInstance(ASoullessBlade.ExtraLoot[Utility.Random(ASoullessBlade.ExtraLoot.Length)]));
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (!InRange(from, 2) && Utility.RandomDouble() < 0.05)
			{
				FixedParticles(0x375A, 1, 17, 0x7DA, 0x960, 0x3, EffectLayer.Waist);
				MadSquirrel summon = new MadSquirrel(from, 1.0);
				summon.MoveToWorld(this.Location, this.Map);
			}

			if (Utility.RandomDouble() < 0.01)
			{
				LysanderGathenwale.SummoningRing(this, typeof(DungeonRat));
			}

			if (Utility.RandomDouble() < 0.005)
			{
				LysanderGathenwale.SummoningRing(this, typeof(Ratman));
				Server.Regions.KhaldunRegion.DropHealthOrb(this);
			}

			if (Utility.RandomDouble() < 0.005)
			{
				LysanderGathenwale.SummoningRing(this, typeof(RatmanArcher));
			}

			if (Utility.RandomDouble() < 0.005)
			{
				LysanderGathenwale.SummoningRing(this, typeof(RatmanMage));
			}

			if (Utility.RandomDouble() < 0.005)
			{
				LysanderGathenwale.SummoningRing(this, typeof(GiantRat));
			}
		}

		public override void OnKilledBy(Mobile mob)
		{
			base.OnKilledBy(mob);

			if (mob == null)
				return;

			if (Teragon.CheckArtifactChance(mob, this))
				Teragon.GiveArtifactTo(mob, this);
		}

		public override int Meat { get { return 10; } }
		public override int Hides { get { return 200; } }
		public override HideType HideType { get { return HideType.Spined; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		public override bool AlwaysMurderer { get { return true; } }

		public Rikkecrat(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}